# Voidburn Enterprise Evidence Summary

**Purpose:** Demonstrate deterministic governance controls for compute spend enforcement  
**Cluster:** {{CLUSTER_NAME}} ({{AWS_REGION}})  
**Timestamp (UTC):** {{UTC_TIMESTAMP}}  
**Target Nodegroup:** {{TARGET_NODEGROUP}}  
**Installer Version:** {{INSTALLER_VERSION}}  

## PASS/FAIL Checklist

### Identity & Scope
- [{{PASS_IDENTITY}}] AWS identity captured (sts get-caller-identity)
- [{{PASS_KUBECTL}}] Cluster reachable via kubectl
- [{{PASS_NODEGROUP}}] Target nodegroup ASG-backed + ON_DEMAND

### Scaler Readiness (Resume Safety)
- [{{PASS_SCALER}}] Scaler exists (Karpenter or Cluster Autoscaler)
- [{{PASS_AUTOSCALER_TAGS}}] ASG tags set correctly (owned)
- [{{PASS_AUTOSCALER_POLICY}}] Autoscaler IAM policy is tag-scoped (scale actions)

### Supply Chain Integrity
- [{{PASS_COSIGN}}] Workload image signature verified (cosign)
- [{{PASS_SBOM}}] SBOM captured (if published)

### IAM Scoping Proof (Governance)
- [{{PASS_IAM_SIM}}] Sentinel IAM is tag-scoped (simulation: tagged resources ALLOW; untagged DENY)

### Deterministic Safety Gates
- [{{PASS_EFS}}] EFS RWX ready (if storage=efs)
- [{{PASS_SECRETS}}] Strict secrets consistent across receiver/workload
- [{{PASS_STRICT_SMOKE}}] Strict checkpoint end-to-end verified (receiver -> workload; signatureOk=true)

### Agent Readiness
- [{{PASS_SENTINEL}}] Sentinel running and configured (no API_KEY missing)

### Dry-Run Proof (Non-destructive)
- [{{PASS_DRYRUN}}] Dry-run evidence generated (no termination executed)

## Evidence Artifacts (files included)
- aws_identity.json
- stack_describe.json
- cluster_autoscaler_policy_tag_scoped.json (+ ARN)
- cosign_verify_workload.json
- workload.sbom.json (if present)
- strict_smoke_response.json
- sentinel_role_arn.txt
- iam_sim_tagged_asg.json / iam_sim_untagged_asg.json
- iam_sim_tagged_snapshot.json / iam_sim_untagged_snapshot.json
- nodes_labels.txt
- asg_before.json / asg_after.json
- sentinel_tail.log / receiver_tail.log / workload_tail.log
- install.log

## Notes
- Enforcement remains under customer control (ARM/DISARM in dashboard).
- This evidence bundle is suitable for change tickets and security review.
