# Example strict checkpoint workload deployment (template).
# Replace {{WORKLOAD_IMAGE}} with your enterprise-approved image (digest pinned recommended).
# This is referenced by the enterprise installer script.

apiVersion: apps/v1
kind: Deployment
metadata:
  name: {{WORKLOAD_SERVICE}}
  namespace: {{WORKLOAD_NAMESPACE}}
spec:
  replicas: 1
  selector:
    matchLabels:
      app: {{WORKLOAD_SERVICE}}
  template:
    metadata:
      labels:
        app: {{WORKLOAD_SERVICE}}
    spec:
      containers:
      - name: workload
        image: {{WORKLOAD_IMAGE}}
        ports:
        - containerPort: 8080
        env:
        - name: PORT
          value: "8080"
        - name: CHECKPOINT_DIR
          value: "/checkpoints"
        - name: WORKLOAD_CHECKPOINT_SECRET
          valueFrom:
            secretKeyRef:
              name: voidburn-checkpoint-secret
              key: secret
        volumeMounts:
        - name: checkpoints
          mountPath: /checkpoints
      volumes:
      - name: checkpoints
        persistentVolumeClaim:
          claimName: checkpoint-pvc
---
apiVersion: v1
kind: Service
metadata:
  name: {{WORKLOAD_SERVICE}}
  namespace: {{WORKLOAD_NAMESPACE}}
spec:
  selector:
    app: {{WORKLOAD_SERVICE}}
  ports:
  - name: http
    port: 8080
    targetPort: 8080
