#!/usr/bin/env bash
set -euo pipefail

die(){ echo "ERROR: $*" >&2; exit 1; }

AWS_PROFILE="${AWS_PROFILE:-}"
AWS_REGION="${AWS_REGION:-}"
CLUSTER_NAME="${CLUSTER_NAME:-}"

[[ -n "$AWS_PROFILE" && -n "$AWS_REGION" && -n "$CLUSTER_NAME" ]] || die "Set AWS_PROFILE, AWS_REGION, CLUSTER_NAME"

AWS="aws --profile $AWS_PROFILE --region $AWS_REGION"

echo "Listing matching stacks..."
$AWS cloudformation list-stacks --stack-status-filter CREATE_COMPLETE UPDATE_COMPLETE \
  --query "StackSummaries[?contains(StackName, 'voidburn-sentinel-${CLUSTER_NAME}')].[StackName,CreationTime]" --output table

echo "Enter STACK_NAME to delete:"
read -r STACK_NAME
[[ -n "$STACK_NAME" ]] || die "STACK_NAME empty"

echo "Deleting stack: $STACK_NAME"
$AWS cloudformation delete-stack --stack-name "$STACK_NAME"
$AWS cloudformation wait stack-delete-complete --stack-name "$STACK_NAME"

echo "Optionally remove namespaces (voidburn, vb-workloads) if dedicated:"
echo "kubectl delete ns voidburn vb-workloads"

echo "Done."
